  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :   Mar 11 12:09:38 2009
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version  SST_Ext_ATP_Index.c#1:csrc:1
   *  \author   Tania Mirzin
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************* Include Files ***********************************/

#include "SST_Ext_ATP_Index.h"
#include "SST_Ext_ATP_IndexTstVectors.h"
#include "MW_ATP_UTIL_funcs.h"
#include "ExtApp_HOST_TST_Message.h"

 #if TST_USE_INDEX_MODULE
/************************ Defines ******************************/
/************************ Enums ********************************/
/************************ Typedefs *****************************/
/************************ Global Data **************************/
extern DxError_t      EXT_TST_ATP_Error;
extern DxUint8_t      EXT_FailureFunctionNameOut[TST_FUNC_STRING_LEN];
extern DxError_t      EXT_TST_TestStatus;

/*****************************************************************************
 * Function Name:                                                           
 *  SST_Ext_Index       
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 *   Test the indexing services  create, bind, unbind, find and delete operations.
 *  
 * Algorithm:       
 *    1.    Call to HOSTQA_ATP_Message function
 *
 *******************************************************************************/ 
 
 
 DxError_t SST_Ext_ATP_Index(  )
 {
 
    /********* TST Variables Definitions ************/
    int                         TST_index =0;
    char                        TST_MasterTestName[TST_FUNC_STRING_LEN] = "SST_Ext_ATP_Index";
    /********* TST Variables initialization *********/
    EXT_TST_TestStatus = TESTPASS;

    /************************************************/
    /*********** Start of test **********************/
    /************************************************/
	
	ATP_LOG_TST_PRINT((SST_TST_MSG,"\n",SEP_ATP_IndexTestData[TST_index].TST_Name,"\n"));

    EXT_TST_ATP_Error = HOSTQA_ATP_Message(DX_SEP_HOST_SEP_PROTOCOL_SST_Index_OP_CODE,
                                           sizeof(EXT_ATP_IndexTestDataStruct),
                                           SEP_ATP_IndexTestData);

	EXT_TST_TestStatus = TST_ATP_CheckErrorReturn(EXT_TST_ATP_Error,"Index", 
		                                           "HOSTQA_ATP_Message",TST_MasterTestName);											
    
		  return EXT_TST_TestStatus;												                        
 }
    
#endif
